//
// AGKeychain.h
// Based on code from "Core Mac OS X and Unix Programming"
// by Mark Dalrymple and Aaron Hillegass
// http://borkware.com/corebook/source-code
//
// Created by Adam Gerson on 3/6/05.
// agerson@mac.com
//
// Modified by AJ and renamed to MCSimpleKeychain

#import <Foundation/Foundation.h>


@interface MCSimpleKeychain : NSObject {

}

// adds if does not exist, modify if does
+ (BOOL)saveKeychainItem:(NSString *)keychainItemName 
			withItemKind:(NSString *)keychainItemKind 
			 forUsername:(NSString *)username 
			withPassword:(NSString *)password;

// returns nil if does not exist
+ (NSString *)passwordFromKeychainItem:(NSString *)keychainItemName 
						  withItemKind:(NSString *)keychainItemKind 
						   forUsername:(NSString *)username;




/* ---------------------- Primitives ---------------------------- */

+ (BOOL)checkForExistanceOfKeychainItem:(NSString *)keychainItemName 
						   withItemKind:(NSString *)keychainItemKind 
							forUsername:(NSString *)username;

+ (BOOL)deleteKeychainItem:(NSString *)keychainItemName 
			  withItemKind:(NSString *)keychainItemKind 
			   forUsername:(NSString *)username;

+ (BOOL)modifyKeychainItem:(NSString *)keychainItemName 
			  withItemKind:(NSString *)keychainItemKind 
			   forUsername:(NSString *)username 
		   withNewPassword:(NSString *)newPassword;

+ (BOOL)addKeychainItem:(NSString *)keychainItemName 
		   withItemKind:(NSString *)keychainItemKind 
			forUsername:(NSString *)username 
		   withPassword:(NSString *)password;

+ (NSString *)getPasswordFromKeychainItem:(NSString *)keychainItemName 
							 withItemKind:(NSString *)keychainItemKind 
							  forUsername:(NSString *)username;



@end
